/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.furniture;

import com.badlogic.gdx.graphics.Color;
import java.util.EnumMap;
import org.apache.commons.lang3.NotImplementedException;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.assets.model.WallType;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;

public class DoorwayEntityAttributes
implements EntityAttributes {
    private long seed;
    private WallType attachedWallType;
    private EntityAssetOrientation orientation;
    private EnumMap<GameMaterialType, GameMaterial> materials = new EnumMap(GameMaterialType.class);
    private GameMaterialType primaryMaterialType;

    public DoorwayEntityAttributes(long seed) {
        this.seed = seed;
    }

    public WallType getAttachedWallType() {
        return this.attachedWallType;
    }

    public void setAttachedWallType(WallType attachedWallType) {
        this.attachedWallType = attachedWallType;
    }

    public GameMaterial getAttachedWallMaterial() {
        return this.materials.get((Object)this.primaryMaterialType);
    }

    public void setAttachedWallMaterial(GameMaterial attachedWallMaterial) {
        this.materials.put(attachedWallMaterial.getMaterialType(), attachedWallMaterial);
        this.primaryMaterialType = attachedWallMaterial.getMaterialType();
    }

    public EntityAssetOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(EntityAssetOrientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public Color getColor(ColoringLayer coloringLayer) {
        GameMaterialType materialType = coloringLayer.getLinkedMaterialType();
        if (materialType != null) {
            GameMaterial gameMaterial = this.materials.get((Object)materialType);
            if (gameMaterial != null) {
                return gameMaterial.getColor();
            }
            return null;
        }
        return null;
    }

    @Override
    public EntityAttributes clone() {
        throw new NotImplementedException("clone() not yet implemented for " + this.getClass().getSimpleName());
    }

    public EnumMap<GameMaterialType, GameMaterial> getMaterials() {
        return this.materials;
    }

    public void setMaterials(EnumMap<GameMaterialType, GameMaterial> materials) {
        this.materials = materials;
    }

    public GameMaterialType getPrimaryMaterialType() {
        return this.primaryMaterialType;
    }

    public void setPrimaryMaterialType(GameMaterialType primaryMaterialType) {
        this.primaryMaterialType = primaryMaterialType;
    }
}

